#!/usr/bin/env python3
import os, sys, subprocess
from datetime import datetime, timezone

HERE = os.path.dirname(os.path.abspath(__file__))
ROOT = os.path.dirname(HERE)

def main():
    ts = datetime.now(timezone.utc).strftime("%Y-%m-%dT%H-%M-%SZ")
    outdir = os.path.join(ROOT, "runs", ts)
    os.makedirs(outdir, exist_ok=True)

    engine = os.path.join(ROOT, "engines", "engine_f16_horizon_v2.py")
    manifest = os.path.join(ROOT, "config", "manifest_f16_v2.json")

    cmd = [sys.executable, engine, "--manifest", manifest, "--outdir", outdir]
    print(">> Running:", " ".join(cmd))
    proc = subprocess.run(cmd, cwd=ROOT, text=True, capture_output=True)
    print(proc.stdout)
    if proc.stderr:
        print(proc.stderr, file=sys.stderr)
    print("Artifacts written under:", outdir)

if __name__ == "__main__":
    main()